package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait AdMarkers {
  def unwrap: software.amazon.awssdk.services.mediapackagevod.model.AdMarkers
}
object AdMarkers {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.AdMarkers
  ): zio.aws.mediapackagevod.model.AdMarkers = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.SCTE35_ENHANCED =>
      val r = SCTE35_ENHANCED
      r
    case software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.PASSTHROUGH =>
      val r = PASSTHROUGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.AdMarkers =
      software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.mediapackagevod.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.AdMarkers =
      software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.NONE
  }
  case object SCTE35_ENHANCED extends zio.aws.mediapackagevod.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.AdMarkers =
      software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.SCTE35_ENHANCED
  }
  case object PASSTHROUGH extends zio.aws.mediapackagevod.model.AdMarkers {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.AdMarkers =
      software.amazon.awssdk.services.mediapackagevod.model.AdMarkers.PASSTHROUGH
  }
}
