package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: __string,
    tags: Map[__string, __string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.TagResourceRequest.ReadOnly =
    zio.aws.mediapackagevod.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.TagResourceRequest =
      zio.aws.mediapackagevod.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: __string
    def tags: Map[__string, __string]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[__string, __string]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest
  ) extends zio.aws.mediapackagevod.model.TagResourceRequest.ReadOnly {
    override val resourceArn: __string = impl.resourceArn(): __string
    override val tags: Map[__string, __string] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: __string) -> (value: __string)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest
  ): zio.aws.mediapackagevod.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
