package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAssetRequest(
    id: __string,
    packagingGroupId: __string,
    resourceId: Optional[__string] = Optional.Absent,
    sourceArn: __string,
    sourceRoleArn: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest = {
    import CreateAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest
      .builder()
      .id(id: java.lang.String)
      .packagingGroupId(packagingGroupId: java.lang.String)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .sourceArn(sourceArn: java.lang.String)
      .sourceRoleArn(sourceRoleArn: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.CreateAssetRequest.ReadOnly =
    zio.aws.mediapackagevod.model.CreateAssetRequest.wrap(buildAwsValue())
}
object CreateAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.CreateAssetRequest =
      zio.aws.mediapackagevod.model.CreateAssetRequest(
        id,
        packagingGroupId,
        resourceId.map(value => value),
        sourceArn,
        sourceRoleArn,
        tags.map(value => value)
      )
    def id: __string
    def packagingGroupId: __string
    def resourceId: Optional[__string]
    def sourceArn: __string
    def sourceRoleArn: __string
    def tags: Optional[Map[__string, __string]]
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getPackagingGroupId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(packagingGroupId)
    def getResourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getSourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(sourceArn)
    def getSourceRoleArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceRoleArn)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest
  ) extends zio.aws.mediapackagevod.model.CreateAssetRequest.ReadOnly {
    override val id: __string = impl.id(): __string
    override val packagingGroupId: __string = impl.packagingGroupId(): __string
    override val resourceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: __string)
    override val sourceArn: __string = impl.sourceArn(): __string
    override val sourceRoleArn: __string = impl.sourceRoleArn(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest
  ): zio.aws.mediapackagevod.model.CreateAssetRequest.ReadOnly = new Wrapper(
    impl
  )
}
