package zio.aws.mediapackagevod
import zio.aws.mediapackagevod.model.ListTagsForResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.mediapackagevod.model.{
  DeleteAssetRequest,
  DescribePackagingGroupRequest,
  ListPackagingGroupsRequest,
  CreatePackagingConfigurationRequest,
  ListTagsForResourceRequest,
  CreateAssetRequest,
  DeletePackagingConfigurationRequest,
  ListAssetsRequest,
  DeletePackagingGroupRequest,
  UntagResourceRequest,
  ConfigureLogsRequest,
  CreatePackagingGroupRequest,
  DescribeAssetRequest,
  DescribePackagingConfigurationRequest,
  UpdatePackagingGroupRequest,
  ListPackagingConfigurationsRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.mediapackagevod.model.{
  AssetShallow,
  DescribePackagingGroupResponse,
  ListPackagingGroupsResponse,
  CreateAssetResponse,
  CreatePackagingGroupResponse,
  ListPackagingConfigurationsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UpdatePackagingGroupResponse,
  DeleteAssetResponse,
  CreatePackagingConfigurationResponse,
  ConfigureLogsResponse,
  DeletePackagingConfigurationResponse,
  DescribePackagingConfigurationResponse,
  PackagingGroup,
  TagResourceResponse,
  DescribeAssetResponse,
  PackagingConfiguration,
  ListAssetsResponse,
  DeletePackagingGroupResponse
}
import software.amazon.awssdk.services.mediapackagevod.{
  MediaPackageVodAsyncClientBuilder,
  MediaPackageVodAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MediaPackageVod extends AspectSupport[MediaPackageVod] {
  val api: MediaPackageVodAsyncClient
  def createPackagingConfiguration(
      request: CreatePackagingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly
  ]
  def describeAsset(
      request: DescribeAssetRequest
  ): IO[AwsError, zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly]
  def configureLogs(
      request: ConfigureLogsRequest
  ): IO[AwsError, zio.aws.mediapackagevod.model.ConfigureLogsResponse.ReadOnly]
  def listPackagingConfigurations(
      request: ListPackagingConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly
  ]
  def listPackagingConfigurationsPaginated(
      request: ListPackagingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly
  ]
  def listAssets(
      request: ListAssetsRequest
  ): ZStream[Any, AwsError, zio.aws.mediapackagevod.model.AssetShallow.ReadOnly]
  def listAssetsPaginated(
      request: ListAssetsRequest
  ): IO[AwsError, zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly]
  def describePackagingConfiguration(
      request: DescribePackagingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly
  ]
  def deletePackagingGroup(request: DeletePackagingGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagevod.model.DeletePackagingGroupResponse.ReadOnly
  ]
  def createAsset(
      request: CreateAssetRequest
  ): IO[AwsError, zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def deletePackagingConfiguration(
      request: DeletePackagingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.mediapackagevod.model.DeletePackagingConfigurationResponse.ReadOnly
  ]
  def deleteAsset(
      request: DeleteAssetRequest
  ): IO[AwsError, zio.aws.mediapackagevod.model.DeleteAssetResponse.ReadOnly]
  def describePackagingGroup(request: DescribePackagingGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def listPackagingGroups(request: ListPackagingGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly
  ]
  def listPackagingGroupsPaginated(request: ListPackagingGroupsRequest): IO[
    AwsError,
    zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly
  ]
  def updatePackagingGroup(request: UpdatePackagingGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagevod.model.UpdatePackagingGroupResponse.ReadOnly
  ]
  def createPackagingGroup(request: CreatePackagingGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagevod.model.CreatePackagingGroupResponse.ReadOnly
  ]
}
object MediaPackageVod {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaPackageVod] =
    customized(identity)
  def customized(
      customization: MediaPackageVodAsyncClientBuilder => MediaPackageVodAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaPackageVod] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MediaPackageVodAsyncClientBuilder => MediaPackageVodAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MediaPackageVod] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MediaPackageVodAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaPackageVodAsyncClient, MediaPackageVodAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      MediaPackageVodAsyncClient,
      MediaPackageVodAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new MediaPackageVodImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MediaPackageVodImpl[R](
      override val api: MediaPackageVodAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaPackageVod
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaPackageVod"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaPackageVodImpl[R1] = new MediaPackageVodImpl(api, newAspect, r)
    def createPackagingConfiguration(
        request: CreatePackagingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest,
      CreatePackagingConfigurationResponse
    ]("createPackagingConfiguration", api.createPackagingConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.wrap
    ).provideEnvironment(r)
    def describeAsset(request: DescribeAssetRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetRequest,
      DescribeAssetResponse
    ]("describeAsset", api.describeAsset)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.DescribeAssetResponse.wrap)
      .provideEnvironment(r)
    def configureLogs(request: ConfigureLogsRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.ConfigureLogsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.ConfigureLogsRequest,
      ConfigureLogsResponse
    ]("configureLogs", api.configureLogs)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.ConfigureLogsResponse.wrap)
      .provideEnvironment(r)
    def listPackagingConfigurations(
        request: ListPackagingConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest,
      ListPackagingConfigurationsResponse,
      PackagingConfiguration
    ](
      "listPackagingConfigurations",
      api.listPackagingConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packagingConfigurations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.mediapackagevod.model.PackagingConfiguration.wrap(item)
      )
      .provideEnvironment(r)
    def listPackagingConfigurationsPaginated(
        request: ListPackagingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest,
      ListPackagingConfigurationsResponse
    ]("listPackagingConfigurations", api.listPackagingConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def listAssets(request: ListAssetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.AssetShallow.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest,
      ListAssetsResponse,
      AssetShallow
    ](
      "listAssets",
      api.listAssets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.assets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediapackagevod.model.AssetShallow.wrap(item))
      .provideEnvironment(r)
    def listAssetsPaginated(
        request: ListAssetsRequest
    ): IO[AwsError, zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest,
        ListAssetsResponse
      ]("listAssets", api.listAssets)(request.buildAwsValue())
        .map(zio.aws.mediapackagevod.model.ListAssetsResponse.wrap)
        .provideEnvironment(r)
    def describePackagingConfiguration(
        request: DescribePackagingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationRequest,
      DescribePackagingConfigurationResponse
    ]("describePackagingConfiguration", api.describePackagingConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.wrap
    ).provideEnvironment(r)
    def deletePackagingGroup(request: DeletePackagingGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.DeletePackagingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingGroupRequest,
      DeletePackagingGroupResponse
    ]("deletePackagingGroup", api.deletePackagingGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.DeletePackagingGroupResponse.wrap)
      .provideEnvironment(r)
    def createAsset(request: CreateAssetRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.CreateAssetRequest,
      CreateAssetResponse
    ]("createAsset", api.createAsset)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.CreateAssetResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackagevod.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deletePackagingConfiguration(
        request: DeletePackagingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.mediapackagevod.model.DeletePackagingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.DeletePackagingConfigurationRequest,
      DeletePackagingConfigurationResponse
    ]("deletePackagingConfiguration", api.deletePackagingConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.mediapackagevod.model.DeletePackagingConfigurationResponse.wrap
    ).provideEnvironment(r)
    def deleteAsset(request: DeleteAssetRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.DeleteAssetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.DeleteAssetRequest,
      DeleteAssetResponse
    ]("deleteAsset", api.deleteAsset)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.DeleteAssetResponse.wrap)
      .provideEnvironment(r)
    def describePackagingGroup(request: DescribePackagingGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupRequest,
      DescribePackagingGroupResponse
    ]("describePackagingGroup", api.describePackagingGroup)(
      request.buildAwsValue()
    ).map(zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackagevod.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listPackagingGroups(request: ListPackagingGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest,
      ListPackagingGroupsResponse,
      PackagingGroup
    ](
      "listPackagingGroups",
      api.listPackagingGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packagingGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mediapackagevod.model.PackagingGroup.wrap(item))
      .provideEnvironment(r)
    def listPackagingGroupsPaginated(request: ListPackagingGroupsRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest,
      ListPackagingGroupsResponse
    ]("listPackagingGroups", api.listPackagingGroups)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.wrap)
      .provideEnvironment(r)
    def updatePackagingGroup(request: UpdatePackagingGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.UpdatePackagingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest,
      UpdatePackagingGroupResponse
    ]("updatePackagingGroup", api.updatePackagingGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.UpdatePackagingGroupResponse.wrap)
      .provideEnvironment(r)
    def createPackagingGroup(request: CreatePackagingGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagevod.model.CreatePackagingGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest,
      CreatePackagingGroupResponse
    ]("createPackagingGroup", api.createPackagingGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagevod.model.CreatePackagingGroupResponse.wrap)
      .provideEnvironment(r)
  }
  def createPackagingConfiguration(
      request: CreatePackagingConfigurationRequest
  ): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPackagingConfiguration(request))
  def describeAsset(request: DescribeAssetRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAsset(request))
  def configureLogs(request: ConfigureLogsRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.ConfigureLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureLogs(request))
  def listPackagingConfigurations(
      request: ListPackagingConfigurationsRequest
  ): ZStream[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackagingConfigurations(request))
  def listPackagingConfigurationsPaginated(
      request: ListPackagingConfigurationsRequest
  ): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackagingConfigurationsPaginated(request))
  def listAssets(request: ListAssetsRequest): ZStream[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.AssetShallow.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssets(request))
  def listAssetsPaginated(request: ListAssetsRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssetsPaginated(request))
  def describePackagingConfiguration(
      request: DescribePackagingConfigurationRequest
  ): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackagingConfiguration(request))
  def deletePackagingGroup(request: DeletePackagingGroupRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.DeletePackagingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePackagingGroup(request))
  def createAsset(request: CreateAssetRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAsset(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.mediapackagevod.MediaPackageVod, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def deletePackagingConfiguration(
      request: DeletePackagingConfigurationRequest
  ): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.DeletePackagingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePackagingConfiguration(request))
  def deleteAsset(request: DeleteAssetRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.DeleteAssetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAsset(request))
  def describePackagingGroup(request: DescribePackagingGroupRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackagingGroup(request))
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZIO[zio.aws.mediapackagevod.MediaPackageVod, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.mediapackagevod.MediaPackageVod, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listPackagingGroups(request: ListPackagingGroupsRequest): ZStream[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackagingGroups(request))
  def listPackagingGroupsPaginated(request: ListPackagingGroupsRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackagingGroupsPaginated(request))
  def updatePackagingGroup(request: UpdatePackagingGroupRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.UpdatePackagingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePackagingGroup(request))
  def createPackagingGroup(request: CreatePackagingGroupRequest): ZIO[
    zio.aws.mediapackagevod.MediaPackageVod,
    AwsError,
    zio.aws.mediapackagevod.model.CreatePackagingGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPackagingGroup(request))
}
