package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionMethod {
  def unwrap
      : software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod
}
object EncryptionMethod {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod
  ): zio.aws.mediapackagevod.model.EncryptionMethod = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod.AES_128 =>
      val r = AES_128
      r
    case software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod.SAMPLE_AES =>
      val r = SAMPLE_AES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.EncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod =
      software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object AES_128 extends zio.aws.mediapackagevod.model.EncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod =
      software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod.AES_128
  }
  case object SAMPLE_AES
      extends zio.aws.mediapackagevod.model.EncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod =
      software.amazon.awssdk.services.mediapackagevod.model.EncryptionMethod.SAMPLE_AES
  }
}
