package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PackagingGroup(
    arn: Optional[__string] = Optional.Absent,
    authorization: Optional[zio.aws.mediapackagevod.model.Authorization] =
      Optional.Absent,
    domainName: Optional[__string] = Optional.Absent,
    egressAccessLogs: Optional[zio.aws.mediapackagevod.model.EgressAccessLogs] =
      Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup = {
    import PackagingGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly =
    zio.aws.mediapackagevod.model.PackagingGroup.wrap(buildAwsValue())
}
object PackagingGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.PackagingGroup =
      zio.aws.mediapackagevod.model.PackagingGroup(
        arn.map(value => value),
        authorization.map(value => value.asEditable),
        domainName.map(value => value),
        egressAccessLogs.map(value => value.asEditable),
        id.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def authorization
        : Optional[zio.aws.mediapackagevod.model.Authorization.ReadOnly]
    def domainName: Optional[__string]
    def egressAccessLogs
        : Optional[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly]
    def id: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getDomainName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup
  ) extends zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val authorization
        : Optional[zio.aws.mediapackagevod.model.Authorization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorization())
        .map(value => zio.aws.mediapackagevod.model.Authorization.wrap(value))
    override val domainName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => value: __string)
    override val egressAccessLogs
        : Optional[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressAccessLogs())
        .map(value =>
          zio.aws.mediapackagevod.model.EgressAccessLogs.wrap(value)
        )
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.PackagingGroup
  ): zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly = new Wrapper(impl)
}
