package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPackagingConfigurationsResponse(
    nextToken: Optional[__string] = Optional.Absent,
    packagingConfigurations: Optional[
      Iterable[zio.aws.mediapackagevod.model.PackagingConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse = {
    import ListPackagingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        packagingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packagingConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly =
    zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListPackagingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse =
      zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse(
        nextToken.map(value => value),
        packagingConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[__string]
    def packagingConfigurations: Optional[
      List[zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackagingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "packagingConfigurations",
      packagingConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse
  ) extends zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val packagingConfigurations: Optional[
      List[zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.packagingConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagevod.model.PackagingConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsResponse
  ): zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
