package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DashEncryption(
    spekeKeyProvider: zio.aws.mediapackagevod.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DashEncryption = {
    import DashEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DashEncryption
      .builder()
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.DashEncryption.ReadOnly =
    zio.aws.mediapackagevod.model.DashEncryption.wrap(buildAwsValue())
}
object DashEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DashEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.DashEncryption =
      zio.aws.mediapackagevod.model.DashEncryption(spekeKeyProvider.asEditable)
    def spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashEncryption
  ) extends zio.aws.mediapackagevod.model.DashEncryption.ReadOnly {
    override val spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackagevod.model.SpekeKeyProvider
        .wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashEncryption
  ): zio.aws.mediapackagevod.model.DashEncryption.ReadOnly = new Wrapper(impl)
}
