package zio.aws.mediapackagevod.model
import zio.prelude.data.Optional
import zio.aws.mediapackagevod.model.primitives.{__string, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPackagingGroupsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest = {
    import ListPackagingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.ListPackagingGroupsRequest.ReadOnly =
    zio.aws.mediapackagevod.model.ListPackagingGroupsRequest
      .wrap(buildAwsValue())
}
object ListPackagingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.ListPackagingGroupsRequest =
      zio.aws.mediapackagevod.model.ListPackagingGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
  ) extends zio.aws.mediapackagevod.model.ListPackagingGroupsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mediapackagevod.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
  ): zio.aws.mediapackagevod.model.ListPackagingGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
