package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePackagingGroupRequest(
    authorization: Optional[zio.aws.mediapackagevod.model.Authorization] =
      Optional.Absent,
    egressAccessLogs: Optional[zio.aws.mediapackagevod.model.EgressAccessLogs] =
      Optional.Absent,
    id: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest = {
    import CreatePackagingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
      .builder()
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .id(id: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.CreatePackagingGroupRequest.ReadOnly =
    zio.aws.mediapackagevod.model.CreatePackagingGroupRequest
      .wrap(buildAwsValue())
}
object CreatePackagingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.CreatePackagingGroupRequest =
      zio.aws.mediapackagevod.model.CreatePackagingGroupRequest(
        authorization.map(value => value.asEditable),
        egressAccessLogs.map(value => value.asEditable),
        id,
        tags.map(value => value)
      )
    def authorization
        : Optional[zio.aws.mediapackagevod.model.Authorization.ReadOnly]
    def egressAccessLogs
        : Optional[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly]
    def id: __string
    def tags: Optional[Map[__string, __string]]
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
  ) extends zio.aws.mediapackagevod.model.CreatePackagingGroupRequest.ReadOnly {
    override val authorization
        : Optional[zio.aws.mediapackagevod.model.Authorization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorization())
        .map(value => zio.aws.mediapackagevod.model.Authorization.wrap(value))
    override val egressAccessLogs
        : Optional[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressAccessLogs())
        .map(value =>
          zio.aws.mediapackagevod.model.EgressAccessLogs.wrap(value)
        )
    override val id: __string = impl.id(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
  ): zio.aws.mediapackagevod.model.CreatePackagingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
