package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MssEncryption(
    spekeKeyProvider: zio.aws.mediapackagevod.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.MssEncryption = {
    import MssEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.MssEncryption
      .builder()
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.MssEncryption.ReadOnly =
    zio.aws.mediapackagevod.model.MssEncryption.wrap(buildAwsValue())
}
object MssEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.MssEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.MssEncryption =
      zio.aws.mediapackagevod.model.MssEncryption(spekeKeyProvider.asEditable)
    def spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.MssEncryption
  ) extends zio.aws.mediapackagevod.model.MssEncryption.ReadOnly {
    override val spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackagevod.model.SpekeKeyProvider
        .wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.MssEncryption
  ): zio.aws.mediapackagevod.model.MssEncryption.ReadOnly = new Wrapper(impl)
}
