package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAssetsResponse(
    assets: Optional[Iterable[zio.aws.mediapackagevod.model.AssetShallow]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse = {
    import ListAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse
      .builder()
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly =
    zio.aws.mediapackagevod.model.ListAssetsResponse.wrap(buildAwsValue())
}
object ListAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.ListAssetsResponse =
      zio.aws.mediapackagevod.model.ListAssetsResponse(
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def assets
        : Optional[List[zio.aws.mediapackagevod.model.AssetShallow.ReadOnly]]
    def nextToken: Optional[__string]
    def getAssets: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.AssetShallow.ReadOnly
    ]] = AwsError.unwrapOptionField("assets", assets)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse
  ) extends zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly {
    override val assets
        : Optional[List[zio.aws.mediapackagevod.model.AssetShallow.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagevod.model.AssetShallow.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse
  ): zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
