package zio.aws.mediapackagevod.model
import zio.prelude.data.Optional
import zio.aws.mediapackagevod.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DashManifest(
    manifestLayout: Optional[zio.aws.mediapackagevod.model.ManifestLayout] =
      Optional.Absent,
    manifestName: Optional[__string] = Optional.Absent,
    minBufferTimeSeconds: Optional[__integer] = Optional.Absent,
    profile: Optional[zio.aws.mediapackagevod.model.Profile] = Optional.Absent,
    scteMarkersSource: Optional[
      zio.aws.mediapackagevod.model.ScteMarkersSource
    ] = Optional.Absent,
    streamSelection: Optional[zio.aws.mediapackagevod.model.StreamSelection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DashManifest = {
    import DashManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DashManifest
      .builder()
      .optionallyWith(manifestLayout.map(value => value.unwrap))(
        _.manifestLayout
      )
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(minBufferTimeSeconds.map(value => value: Integer))(
        _.minBufferTimeSeconds
      )
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(scteMarkersSource.map(value => value.unwrap))(
        _.scteMarkersSource
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.DashManifest.ReadOnly =
    zio.aws.mediapackagevod.model.DashManifest.wrap(buildAwsValue())
}
object DashManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DashManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.DashManifest =
      zio.aws.mediapackagevod.model.DashManifest(
        manifestLayout.map(value => value),
        manifestName.map(value => value),
        minBufferTimeSeconds.map(value => value),
        profile.map(value => value),
        scteMarkersSource.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def manifestLayout: Optional[zio.aws.mediapackagevod.model.ManifestLayout]
    def manifestName: Optional[__string]
    def minBufferTimeSeconds: Optional[__integer]
    def profile: Optional[zio.aws.mediapackagevod.model.Profile]
    def scteMarkersSource
        : Optional[zio.aws.mediapackagevod.model.ScteMarkersSource]
    def streamSelection
        : Optional[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly]
    def getManifestLayout
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.ManifestLayout] =
      AwsError.unwrapOptionField("manifestLayout", manifestLayout)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getMinBufferTimeSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minBufferTimeSeconds", minBufferTimeSeconds)
    def getProfile: ZIO[Any, AwsError, zio.aws.mediapackagevod.model.Profile] =
      AwsError.unwrapOptionField("profile", profile)
    def getScteMarkersSource
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.ScteMarkersSource] =
      AwsError.unwrapOptionField("scteMarkersSource", scteMarkersSource)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashManifest
  ) extends zio.aws.mediapackagevod.model.DashManifest.ReadOnly {
    override val manifestLayout
        : Optional[zio.aws.mediapackagevod.model.ManifestLayout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestLayout())
        .map(value => zio.aws.mediapackagevod.model.ManifestLayout.wrap(value))
    override val manifestName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.manifestName())
      .map(value => value: __string)
    override val minBufferTimeSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minBufferTimeSeconds())
        .map(value => value: __integer)
    override val profile: Optional[zio.aws.mediapackagevod.model.Profile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profile())
        .map(value => zio.aws.mediapackagevod.model.Profile.wrap(value))
    override val scteMarkersSource
        : Optional[zio.aws.mediapackagevod.model.ScteMarkersSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scteMarkersSource())
        .map(value =>
          zio.aws.mediapackagevod.model.ScteMarkersSource.wrap(value)
        )
    override val streamSelection
        : Optional[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSelection())
        .map(value => zio.aws.mediapackagevod.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashManifest
  ): zio.aws.mediapackagevod.model.DashManifest.ReadOnly = new Wrapper(impl)
}
