package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigureLogsRequest(
    egressAccessLogs: Optional[zio.aws.mediapackagevod.model.EgressAccessLogs] =
      Optional.Absent,
    id: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ConfigureLogsRequest = {
    import ConfigureLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ConfigureLogsRequest
      .builder()
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.ConfigureLogsRequest.ReadOnly =
    zio.aws.mediapackagevod.model.ConfigureLogsRequest.wrap(buildAwsValue())
}
object ConfigureLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ConfigureLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.ConfigureLogsRequest =
      zio.aws.mediapackagevod.model.ConfigureLogsRequest(
        egressAccessLogs.map(value => value.asEditable),
        id
      )
    def egressAccessLogs
        : Optional[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly]
    def id: __string
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ConfigureLogsRequest
  ) extends zio.aws.mediapackagevod.model.ConfigureLogsRequest.ReadOnly {
    override val egressAccessLogs
        : Optional[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressAccessLogs())
        .map(value =>
          zio.aws.mediapackagevod.model.EgressAccessLogs.wrap(value)
        )
    override val id: __string = impl.id(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ConfigureLogsRequest
  ): zio.aws.mediapackagevod.model.ConfigureLogsRequest.ReadOnly = new Wrapper(
    impl
  )
}
