package zio.aws.mediapackagevod.model
import zio.prelude.data.Optional
import zio.aws.mediapackagevod.model.primitives.__integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StreamSelection(
    maxVideoBitsPerSecond: Optional[__integer] = Optional.Absent,
    minVideoBitsPerSecond: Optional[__integer] = Optional.Absent,
    streamOrder: Optional[zio.aws.mediapackagevod.model.StreamOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.StreamSelection = {
    import StreamSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
      .builder()
      .optionallyWith(maxVideoBitsPerSecond.map(value => value: Integer))(
        _.maxVideoBitsPerSecond
      )
      .optionallyWith(minVideoBitsPerSecond.map(value => value: Integer))(
        _.minVideoBitsPerSecond
      )
      .optionallyWith(streamOrder.map(value => value.unwrap))(_.streamOrder)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.StreamSelection.ReadOnly =
    zio.aws.mediapackagevod.model.StreamSelection.wrap(buildAwsValue())
}
object StreamSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.StreamSelection =
      zio.aws.mediapackagevod.model.StreamSelection(
        maxVideoBitsPerSecond.map(value => value),
        minVideoBitsPerSecond.map(value => value),
        streamOrder.map(value => value)
      )
    def maxVideoBitsPerSecond: Optional[__integer]
    def minVideoBitsPerSecond: Optional[__integer]
    def streamOrder: Optional[zio.aws.mediapackagevod.model.StreamOrder]
    def getMaxVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxVideoBitsPerSecond", maxVideoBitsPerSecond)
    def getMinVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minVideoBitsPerSecond", minVideoBitsPerSecond)
    def getStreamOrder
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.StreamOrder] =
      AwsError.unwrapOptionField("streamOrder", streamOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
  ) extends zio.aws.mediapackagevod.model.StreamSelection.ReadOnly {
    override val maxVideoBitsPerSecond: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxVideoBitsPerSecond())
        .map(value => value: __integer)
    override val minVideoBitsPerSecond: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minVideoBitsPerSecond())
        .map(value => value: __integer)
    override val streamOrder
        : Optional[zio.aws.mediapackagevod.model.StreamOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamOrder())
        .map(value => zio.aws.mediapackagevod.model.StreamOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
  ): zio.aws.mediapackagevod.model.StreamSelection.ReadOnly = new Wrapper(impl)
}
