package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SpekeKeyProvider(
    roleArn: __string,
    systemIds: Iterable[__string],
    url: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider = {
    import SpekeKeyProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
      .builder()
      .roleArn(roleArn: java.lang.String)
      .systemIds(systemIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .url(url: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly =
    zio.aws.mediapackagevod.model.SpekeKeyProvider.wrap(buildAwsValue())
}
object SpekeKeyProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.SpekeKeyProvider =
      zio.aws.mediapackagevod.model.SpekeKeyProvider(roleArn, systemIds, url)
    def roleArn: __string
    def systemIds: List[__string]
    def url: __string
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getSystemIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(systemIds)
    def getUrl: ZIO[Any, Nothing, __string] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
  ) extends zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly {
    override val roleArn: __string = impl.roleArn(): __string
    override val systemIds: List[__string] = impl
      .systemIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val url: __string = impl.url(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
  ): zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly = new Wrapper(impl)
}
