package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait ManifestLayout {
  def unwrap
      : software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout
}
object ManifestLayout {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout
  ): zio.aws.mediapackagevod.model.ManifestLayout = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout.FULL =>
      val r = FULL
      r
    case software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout.COMPACT =>
      val r = COMPACT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.ManifestLayout {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout =
      software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.mediapackagevod.model.ManifestLayout {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout =
      software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout.FULL
  }
  case object COMPACT extends zio.aws.mediapackagevod.model.ManifestLayout {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout =
      software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout.COMPACT
  }
}
