package zio.aws.mediapackagevod.model
import zio.prelude.data.Optional
import zio.aws.mediapackagevod.model.primitives.{__string, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPackagingConfigurationsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    packagingGroupId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest = {
    import ListPackagingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(packagingGroupId.map(value => value: java.lang.String))(
        _.packagingGroupId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.ListPackagingConfigurationsRequest.ReadOnly =
    zio.aws.mediapackagevod.model.ListPackagingConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListPackagingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagevod.model.ListPackagingConfigurationsRequest =
      zio.aws.mediapackagevod.model.ListPackagingConfigurationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        packagingGroupId.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def packagingGroupId: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackagingGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("packagingGroupId", packagingGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest
  ) extends zio.aws.mediapackagevod.model.ListPackagingConfigurationsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mediapackagevod.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val packagingGroupId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.packagingGroupId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingConfigurationsRequest
  ): zio.aws.mediapackagevod.model.ListPackagingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
