package zio.aws.mediapackagevod.model
import zio.prelude.data.Optional
import zio.aws.mediapackagevod.model.primitives.{__integer, __boolean}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DashPackage(
    dashManifests: Iterable[zio.aws.mediapackagevod.model.DashManifest],
    encryption: Optional[zio.aws.mediapackagevod.model.DashEncryption] =
      Optional.Absent,
    includeEncoderConfigurationInSegments: Optional[__boolean] =
      Optional.Absent,
    periodTriggers: Optional[
      Iterable[zio.aws.mediapackagevod.model.PeriodTriggersElement]
    ] = Optional.Absent,
    segmentDurationSeconds: Optional[__integer] = Optional.Absent,
    segmentTemplateFormat: Optional[
      zio.aws.mediapackagevod.model.SegmentTemplateFormat
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DashPackage = {
    import DashPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DashPackage
      .builder()
      .dashManifests(dashManifests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        includeEncoderConfigurationInSegments.map(value =>
          value: java.lang.Boolean
        )
      )(_.includeEncoderConfigurationInSegments)
      .optionallyWith(
        periodTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.periodTriggersWithStrings)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(segmentTemplateFormat.map(value => value.unwrap))(
        _.segmentTemplateFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.DashPackage.ReadOnly =
    zio.aws.mediapackagevod.model.DashPackage.wrap(buildAwsValue())
}
object DashPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DashPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.DashPackage =
      zio.aws.mediapackagevod.model.DashPackage(
        dashManifests.map { item =>
          item.asEditable
        },
        encryption.map(value => value.asEditable),
        includeEncoderConfigurationInSegments.map(value => value),
        periodTriggers.map(value => value),
        segmentDurationSeconds.map(value => value),
        segmentTemplateFormat.map(value => value)
      )
    def dashManifests: List[zio.aws.mediapackagevod.model.DashManifest.ReadOnly]
    def encryption
        : Optional[zio.aws.mediapackagevod.model.DashEncryption.ReadOnly]
    def includeEncoderConfigurationInSegments: Optional[__boolean]
    def periodTriggers
        : Optional[List[zio.aws.mediapackagevod.model.PeriodTriggersElement]]
    def segmentDurationSeconds: Optional[__integer]
    def segmentTemplateFormat
        : Optional[zio.aws.mediapackagevod.model.SegmentTemplateFormat]
    def getDashManifests: ZIO[Any, Nothing, List[
      zio.aws.mediapackagevod.model.DashManifest.ReadOnly
    ]] = ZIO.succeed(dashManifests)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.DashEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getIncludeEncoderConfigurationInSegments
        : ZIO[Any, AwsError, __boolean] = AwsError.unwrapOptionField(
      "includeEncoderConfigurationInSegments",
      includeEncoderConfigurationInSegments
    )
    def getPeriodTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.PeriodTriggersElement
    ]] = AwsError.unwrapOptionField("periodTriggers", periodTriggers)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentTemplateFormat: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.SegmentTemplateFormat
    ] =
      AwsError.unwrapOptionField("segmentTemplateFormat", segmentTemplateFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashPackage
  ) extends zio.aws.mediapackagevod.model.DashPackage.ReadOnly {
    override val dashManifests
        : List[zio.aws.mediapackagevod.model.DashManifest.ReadOnly] = impl
      .dashManifests()
      .asScala
      .map { item =>
        zio.aws.mediapackagevod.model.DashManifest.wrap(item)
      }
      .toList
    override val encryption
        : Optional[zio.aws.mediapackagevod.model.DashEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.mediapackagevod.model.DashEncryption.wrap(value))
    override val includeEncoderConfigurationInSegments: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeEncoderConfigurationInSegments())
        .map(value => value: __boolean)
    override val periodTriggers
        : Optional[List[zio.aws.mediapackagevod.model.PeriodTriggersElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.periodTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagevod.model.PeriodTriggersElement.wrap(item)
          }.toList
        )
    override val segmentDurationSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentDurationSeconds())
        .map(value => value: __integer)
    override val segmentTemplateFormat
        : Optional[zio.aws.mediapackagevod.model.SegmentTemplateFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentTemplateFormat())
        .map(value =>
          zio.aws.mediapackagevod.model.SegmentTemplateFormat.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashPackage
  ): zio.aws.mediapackagevod.model.DashPackage.ReadOnly = new Wrapper(impl)
}
