package zio.aws.mediapackagevod
import zio.aws.mediapackagevod.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.mediapackagevod.model.{
  DeleteAssetRequest,
  DescribePackagingGroupRequest,
  ListPackagingGroupsRequest,
  CreatePackagingConfigurationRequest,
  ListTagsForResourceRequest,
  CreateAssetRequest,
  DeletePackagingConfigurationRequest,
  ListAssetsRequest,
  DeletePackagingGroupRequest,
  UntagResourceRequest,
  ConfigureLogsRequest,
  CreatePackagingGroupRequest,
  DescribeAssetRequest,
  DescribePackagingConfigurationRequest,
  UpdatePackagingGroupRequest,
  ListPackagingConfigurationsRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object MediaPackageVodMock extends Mock[MediaPackageVod] {
  object CreatePackagingConfiguration
      extends Effect[
        CreatePackagingConfigurationRequest,
        AwsError,
        zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly
      ]
  object DescribeAsset
      extends Effect[
        DescribeAssetRequest,
        AwsError,
        zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly
      ]
  object ConfigureLogs
      extends Effect[
        ConfigureLogsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.ConfigureLogsResponse.ReadOnly
      ]
  object ListPackagingConfigurations
      extends Stream[
        ListPackagingConfigurationsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly
      ]
  object ListPackagingConfigurationsPaginated
      extends Effect[
        ListPackagingConfigurationsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly
      ]
  object ListAssets
      extends Stream[
        ListAssetsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.AssetShallow.ReadOnly
      ]
  object ListAssetsPaginated
      extends Effect[
        ListAssetsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly
      ]
  object DescribePackagingConfiguration
      extends Effect[
        DescribePackagingConfigurationRequest,
        AwsError,
        zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly
      ]
  object DeletePackagingGroup
      extends Effect[
        DeletePackagingGroupRequest,
        AwsError,
        zio.aws.mediapackagevod.model.DeletePackagingGroupResponse.ReadOnly
      ]
  object CreateAsset
      extends Effect[
        CreateAssetRequest,
        AwsError,
        zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DeletePackagingConfiguration
      extends Effect[
        DeletePackagingConfigurationRequest,
        AwsError,
        zio.aws.mediapackagevod.model.DeletePackagingConfigurationResponse.ReadOnly
      ]
  object DeleteAsset
      extends Effect[
        DeleteAssetRequest,
        AwsError,
        zio.aws.mediapackagevod.model.DeleteAssetResponse.ReadOnly
      ]
  object DescribePackagingGroup
      extends Effect[
        DescribePackagingGroupRequest,
        AwsError,
        zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object ListPackagingGroups
      extends Stream[
        ListPackagingGroupsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly
      ]
  object ListPackagingGroupsPaginated
      extends Effect[
        ListPackagingGroupsRequest,
        AwsError,
        zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly
      ]
  object UpdatePackagingGroup
      extends Effect[
        UpdatePackagingGroupRequest,
        AwsError,
        zio.aws.mediapackagevod.model.UpdatePackagingGroupResponse.ReadOnly
      ]
  object CreatePackagingGroup
      extends Effect[
        CreatePackagingGroupRequest,
        AwsError,
        zio.aws.mediapackagevod.model.CreatePackagingGroupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaPackageVod] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MediaPackageVod] { rts =>
        zio.ZIO.succeed {
          new MediaPackageVod {
            val api: MediaPackageVodAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MediaPackageVod = this
            def createPackagingConfiguration(
                request: CreatePackagingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly
            ] = proxy(CreatePackagingConfiguration, request)
            def describeAsset(request: DescribeAssetRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly
            ] = proxy(DescribeAsset, request)
            def configureLogs(request: ConfigureLogsRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.ConfigureLogsResponse.ReadOnly
            ] = proxy(ConfigureLogs, request)
            def listPackagingConfigurations(
                request: ListPackagingConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mediapackagevod.model.PackagingConfiguration.ReadOnly
            ] = rts.unsafeRun(proxy(ListPackagingConfigurations, request))
            def listPackagingConfigurationsPaginated(
                request: ListPackagingConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagevod.model.ListPackagingConfigurationsResponse.ReadOnly
            ] = proxy(ListPackagingConfigurationsPaginated, request)
            def listAssets(request: ListAssetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.mediapackagevod.model.AssetShallow.ReadOnly
            ] = rts.unsafeRun(proxy(ListAssets, request))
            def listAssetsPaginated(request: ListAssetsRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.ListAssetsResponse.ReadOnly
            ] = proxy(ListAssetsPaginated, request)
            def describePackagingConfiguration(
                request: DescribePackagingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly
            ] = proxy(DescribePackagingConfiguration, request)
            def deletePackagingGroup(request: DeletePackagingGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.DeletePackagingGroupResponse.ReadOnly
            ] = proxy(DeletePackagingGroup, request)
            def createAsset(request: CreateAssetRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly
            ] = proxy(CreateAsset, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def deletePackagingConfiguration(
                request: DeletePackagingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagevod.model.DeletePackagingConfigurationResponse.ReadOnly
            ] = proxy(DeletePackagingConfiguration, request)
            def deleteAsset(request: DeleteAssetRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.DeleteAssetResponse.ReadOnly
            ] = proxy(DeleteAsset, request)
            def describePackagingGroup(
                request: DescribePackagingGroupRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly
            ] = proxy(DescribePackagingGroup, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def listPackagingGroups(
                request: ListPackagingGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly
            ] = rts.unsafeRun(proxy(ListPackagingGroups, request))
            def listPackagingGroupsPaginated(
                request: ListPackagingGroupsRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly
            ] = proxy(ListPackagingGroupsPaginated, request)
            def updatePackagingGroup(request: UpdatePackagingGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.UpdatePackagingGroupResponse.ReadOnly
            ] = proxy(UpdatePackagingGroup, request)
            def createPackagingGroup(request: CreatePackagingGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagevod.model.CreatePackagingGroupResponse.ReadOnly
            ] = proxy(CreatePackagingGroup, request)
          }
        }
      }
    }
  }
}
