package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait ScteMarkersSource {
  def unwrap
      : software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource
}
object ScteMarkersSource {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource
  ): zio.aws.mediapackagevod.model.ScteMarkersSource = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource.SEGMENTS =>
      val r = SEGMENTS
      r
    case software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource.MANIFEST =>
      val r = MANIFEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.ScteMarkersSource {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource =
      software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource.UNKNOWN_TO_SDK_VERSION
  }
  case object SEGMENTS extends zio.aws.mediapackagevod.model.ScteMarkersSource {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource =
      software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource.SEGMENTS
  }
  case object MANIFEST extends zio.aws.mediapackagevod.model.ScteMarkersSource {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource =
      software.amazon.awssdk.services.mediapackagevod.model.ScteMarkersSource.MANIFEST
  }
}
