package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait Profile {
  def unwrap: software.amazon.awssdk.services.mediapackagevod.model.Profile
}
object Profile {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.Profile
  ): zio.aws.mediapackagevod.model.Profile = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.Profile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.Profile.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.mediapackagevod.model.Profile.HBBTV_1_5 =>
      val r = HBBTV_1_5
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.Profile {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.Profile =
      software.amazon.awssdk.services.mediapackagevod.model.Profile.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.mediapackagevod.model.Profile {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.Profile =
      software.amazon.awssdk.services.mediapackagevod.model.Profile.NONE
  }
  case object HBBTV_1_5 extends zio.aws.mediapackagevod.model.Profile {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.Profile =
      software.amazon.awssdk.services.mediapackagevod.model.Profile.HBBTV_1_5
  }
}
