package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MssManifest(
    manifestName: Optional[__string] = Optional.Absent,
    streamSelection: Optional[zio.aws.mediapackagevod.model.StreamSelection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.MssManifest = {
    import MssManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.MssManifest
      .builder()
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.MssManifest.ReadOnly =
    zio.aws.mediapackagevod.model.MssManifest.wrap(buildAwsValue())
}
object MssManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.MssManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.MssManifest =
      zio.aws.mediapackagevod.model.MssManifest(
        manifestName.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def manifestName: Optional[__string]
    def streamSelection
        : Optional[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly]
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.MssManifest
  ) extends zio.aws.mediapackagevod.model.MssManifest.ReadOnly {
    override val manifestName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.manifestName())
      .map(value => value: __string)
    override val streamSelection
        : Optional[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSelection())
        .map(value => zio.aws.mediapackagevod.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.MssManifest
  ): zio.aws.mediapackagevod.model.MssManifest.ReadOnly = new Wrapper(impl)
}
