package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HlsEncryption(
    constantInitializationVector: Optional[__string] = Optional.Absent,
    encryptionMethod: Optional[zio.aws.mediapackagevod.model.EncryptionMethod] =
      Optional.Absent,
    spekeKeyProvider: zio.aws.mediapackagevod.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.HlsEncryption = {
    import HlsEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.HlsEncryption
      .builder()
      .optionallyWith(
        constantInitializationVector.map(value => value: java.lang.String)
      )(_.constantInitializationVector)
      .optionallyWith(encryptionMethod.map(value => value.unwrap))(
        _.encryptionMethod
      )
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.HlsEncryption.ReadOnly =
    zio.aws.mediapackagevod.model.HlsEncryption.wrap(buildAwsValue())
}
object HlsEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.HlsEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.HlsEncryption =
      zio.aws.mediapackagevod.model.HlsEncryption(
        constantInitializationVector.map(value => value),
        encryptionMethod.map(value => value),
        spekeKeyProvider.asEditable
      )
    def constantInitializationVector: Optional[__string]
    def encryptionMethod
        : Optional[zio.aws.mediapackagevod.model.EncryptionMethod]
    def spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    def getConstantInitializationVector: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "constantInitializationVector",
        constantInitializationVector
      )
    def getEncryptionMethod
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.EncryptionMethod] =
      AwsError.unwrapOptionField("encryptionMethod", encryptionMethod)
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.HlsEncryption
  ) extends zio.aws.mediapackagevod.model.HlsEncryption.ReadOnly {
    override val constantInitializationVector: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constantInitializationVector())
        .map(value => value: __string)
    override val encryptionMethod
        : Optional[zio.aws.mediapackagevod.model.EncryptionMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMethod())
        .map(value =>
          zio.aws.mediapackagevod.model.EncryptionMethod.wrap(value)
        )
    override val spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackagevod.model.SpekeKeyProvider
        .wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.HlsEncryption
  ): zio.aws.mediapackagevod.model.HlsEncryption.ReadOnly = new Wrapper(impl)
}
