package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdatePackagingGroupRequest(
    authorization: Option[zio.aws.mediapackagevod.model.Authorization] = None,
    id: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest = {
    import UpdatePackagingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest
      .builder()
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.UpdatePackagingGroupRequest.ReadOnly =
    zio.aws.mediapackagevod.model.UpdatePackagingGroupRequest
      .wrap(buildAwsValue())
}
object UpdatePackagingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.UpdatePackagingGroupRequest =
      zio.aws.mediapackagevod.model.UpdatePackagingGroupRequest(
        authorization.map(value => value.asEditable),
        id
      )
    def authorization
        : Option[zio.aws.mediapackagevod.model.Authorization.ReadOnly]
    def id: __string
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest
  ) extends zio.aws.mediapackagevod.model.UpdatePackagingGroupRequest.ReadOnly {
    override val authorization
        : Option[zio.aws.mediapackagevod.model.Authorization.ReadOnly] = scala
      .Option(impl.authorization())
      .map(value => zio.aws.mediapackagevod.model.Authorization.wrap(value))
    override val id: __string = impl.id(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.UpdatePackagingGroupRequest
  ): zio.aws.mediapackagevod.model.UpdatePackagingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
