package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__integer
import scala.jdk.CollectionConverters.*
final case class StreamSelection(
    maxVideoBitsPerSecond: Option[__integer] = None,
    minVideoBitsPerSecond: Option[__integer] = None,
    streamOrder: Option[zio.aws.mediapackagevod.model.StreamOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.StreamSelection = {
    import StreamSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
      .builder()
      .optionallyWith(maxVideoBitsPerSecond.map(value => value: Integer))(
        _.maxVideoBitsPerSecond
      )
      .optionallyWith(minVideoBitsPerSecond.map(value => value: Integer))(
        _.minVideoBitsPerSecond
      )
      .optionallyWith(streamOrder.map(value => value.unwrap))(_.streamOrder)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.StreamSelection.ReadOnly =
    zio.aws.mediapackagevod.model.StreamSelection.wrap(buildAwsValue())
}
object StreamSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.StreamSelection =
      zio.aws.mediapackagevod.model.StreamSelection(
        maxVideoBitsPerSecond.map(value => value),
        minVideoBitsPerSecond.map(value => value),
        streamOrder.map(value => value)
      )
    def maxVideoBitsPerSecond: Option[__integer]
    def minVideoBitsPerSecond: Option[__integer]
    def streamOrder: Option[zio.aws.mediapackagevod.model.StreamOrder]
    def getMaxVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxVideoBitsPerSecond", maxVideoBitsPerSecond)
    def getMinVideoBitsPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minVideoBitsPerSecond", minVideoBitsPerSecond)
    def getStreamOrder
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.StreamOrder] =
      AwsError.unwrapOptionField("streamOrder", streamOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
  ) extends zio.aws.mediapackagevod.model.StreamSelection.ReadOnly {
    override val maxVideoBitsPerSecond: Option[__integer] =
      scala.Option(impl.maxVideoBitsPerSecond()).map(value => value: __integer)
    override val minVideoBitsPerSecond: Option[__integer] =
      scala.Option(impl.minVideoBitsPerSecond()).map(value => value: __integer)
    override val streamOrder
        : Option[zio.aws.mediapackagevod.model.StreamOrder] = scala
      .Option(impl.streamOrder())
      .map(value => zio.aws.mediapackagevod.model.StreamOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.StreamSelection
  ): zio.aws.mediapackagevod.model.StreamSelection.ReadOnly = new Wrapper(impl)
}
