package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait PeriodTriggersElement {
  def unwrap: software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement
}
object PeriodTriggersElement {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement
  ): zio.aws.mediapackagevod.model.PeriodTriggersElement = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement.ADS =>
      val r = ADS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.PeriodTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement =
      software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement.UNKNOWN_TO_SDK_VERSION
  }
  case object ADS extends zio.aws.mediapackagevod.model.PeriodTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement =
      software.amazon.awssdk.services.mediapackagevod.model.PeriodTriggersElement.ADS
  }
}
