package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__integer
import scala.jdk.CollectionConverters.*
final case class MssPackage(
    encryption: Option[zio.aws.mediapackagevod.model.MssEncryption] = None,
    mssManifests: Iterable[zio.aws.mediapackagevod.model.MssManifest],
    segmentDurationSeconds: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.MssPackage = {
    import MssPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.MssPackage
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .mssManifests(mssManifests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.MssPackage.ReadOnly =
    zio.aws.mediapackagevod.model.MssPackage.wrap(buildAwsValue())
}
object MssPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.MssPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.MssPackage =
      zio.aws.mediapackagevod.model.MssPackage(
        encryption.map(value => value.asEditable),
        mssManifests.map { item =>
          item.asEditable
        },
        segmentDurationSeconds.map(value => value)
      )
    def encryption: Option[zio.aws.mediapackagevod.model.MssEncryption.ReadOnly]
    def mssManifests: List[zio.aws.mediapackagevod.model.MssManifest.ReadOnly]
    def segmentDurationSeconds: Option[__integer]
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.MssEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getMssManifests: ZIO[Any, Nothing, List[
      zio.aws.mediapackagevod.model.MssManifest.ReadOnly
    ]] = ZIO.succeed(mssManifests)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.MssPackage
  ) extends zio.aws.mediapackagevod.model.MssPackage.ReadOnly {
    override val encryption
        : Option[zio.aws.mediapackagevod.model.MssEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackagevod.model.MssEncryption.wrap(value))
    override val mssManifests
        : List[zio.aws.mediapackagevod.model.MssManifest.ReadOnly] = impl
      .mssManifests()
      .asScala
      .map { item =>
        zio.aws.mediapackagevod.model.MssManifest.wrap(item)
      }
      .toList
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.MssPackage
  ): zio.aws.mediapackagevod.model.MssPackage.ReadOnly = new Wrapper(impl)
}
