package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListPackagingGroupsResponse(
    nextToken: Option[__string] = None,
    packagingGroups: Option[
      Iterable[zio.aws.mediapackagevod.model.PackagingGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse = {
    import ListPackagingGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        packagingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packagingGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly =
    zio.aws.mediapackagevod.model.ListPackagingGroupsResponse
      .wrap(buildAwsValue())
}
object ListPackagingGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.ListPackagingGroupsResponse =
      zio.aws.mediapackagevod.model.ListPackagingGroupsResponse(
        nextToken.map(value => value),
        packagingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def packagingGroups
        : Option[List[zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackagingGroups: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("packagingGroups", packagingGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse
  ) extends zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly {
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val packagingGroups
        : Option[List[zio.aws.mediapackagevod.model.PackagingGroup.ReadOnly]] =
      scala
        .Option(impl.packagingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagevod.model.PackagingGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsResponse
  ): zio.aws.mediapackagevod.model.ListPackagingGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
