package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListPackagingGroupsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest = {
    import ListPackagingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.ListPackagingGroupsRequest.ReadOnly =
    zio.aws.mediapackagevod.model.ListPackagingGroupsRequest
      .wrap(buildAwsValue())
}
object ListPackagingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.ListPackagingGroupsRequest =
      zio.aws.mediapackagevod.model.ListPackagingGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
  ) extends zio.aws.mediapackagevod.model.ListPackagingGroupsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediapackagevod.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListPackagingGroupsRequest
  ): zio.aws.mediapackagevod.model.ListPackagingGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
