package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListAssetsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    packagingGroupId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest = {
    import ListAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(packagingGroupId.map(value => value: java.lang.String))(
        _.packagingGroupId
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.ListAssetsRequest.ReadOnly =
    zio.aws.mediapackagevod.model.ListAssetsRequest.wrap(buildAwsValue())
}
object ListAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.ListAssetsRequest =
      zio.aws.mediapackagevod.model.ListAssetsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        packagingGroupId.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def packagingGroupId: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackagingGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("packagingGroupId", packagingGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest
  ) extends zio.aws.mediapackagevod.model.ListAssetsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediapackagevod.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val packagingGroupId: Option[__string] =
      scala.Option(impl.packagingGroupId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest
  ): zio.aws.mediapackagevod.model.ListAssetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
