package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__integer, __boolean}
import scala.jdk.CollectionConverters.*
final case class HlsPackage(
    encryption: Option[zio.aws.mediapackagevod.model.HlsEncryption] = None,
    hlsManifests: Iterable[zio.aws.mediapackagevod.model.HlsManifest],
    includeDvbSubtitles: Option[__boolean] = None,
    segmentDurationSeconds: Option[__integer] = None,
    useAudioRenditionGroup: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.HlsPackage = {
    import HlsPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.HlsPackage
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .hlsManifests(hlsManifests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        includeDvbSubtitles.map(value => value: java.lang.Boolean)
      )(_.includeDvbSubtitles)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(
        useAudioRenditionGroup.map(value => value: java.lang.Boolean)
      )(_.useAudioRenditionGroup)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.HlsPackage.ReadOnly =
    zio.aws.mediapackagevod.model.HlsPackage.wrap(buildAwsValue())
}
object HlsPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.HlsPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.HlsPackage =
      zio.aws.mediapackagevod.model.HlsPackage(
        encryption.map(value => value.asEditable),
        hlsManifests.map { item =>
          item.asEditable
        },
        includeDvbSubtitles.map(value => value),
        segmentDurationSeconds.map(value => value),
        useAudioRenditionGroup.map(value => value)
      )
    def encryption: Option[zio.aws.mediapackagevod.model.HlsEncryption.ReadOnly]
    def hlsManifests: List[zio.aws.mediapackagevod.model.HlsManifest.ReadOnly]
    def includeDvbSubtitles: Option[__boolean]
    def segmentDurationSeconds: Option[__integer]
    def useAudioRenditionGroup: Option[__boolean]
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.HlsEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getHlsManifests: ZIO[Any, Nothing, List[
      zio.aws.mediapackagevod.model.HlsManifest.ReadOnly
    ]] = ZIO.succeed(hlsManifests)
    def getIncludeDvbSubtitles: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("includeDvbSubtitles", includeDvbSubtitles)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getUseAudioRenditionGroup: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("useAudioRenditionGroup", useAudioRenditionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.HlsPackage
  ) extends zio.aws.mediapackagevod.model.HlsPackage.ReadOnly {
    override val encryption
        : Option[zio.aws.mediapackagevod.model.HlsEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackagevod.model.HlsEncryption.wrap(value))
    override val hlsManifests
        : List[zio.aws.mediapackagevod.model.HlsManifest.ReadOnly] = impl
      .hlsManifests()
      .asScala
      .map { item =>
        zio.aws.mediapackagevod.model.HlsManifest.wrap(item)
      }
      .toList
    override val includeDvbSubtitles: Option[__boolean] =
      scala.Option(impl.includeDvbSubtitles()).map(value => value: __boolean)
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
    override val useAudioRenditionGroup: Option[__boolean] =
      scala.Option(impl.useAudioRenditionGroup()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.HlsPackage
  ): zio.aws.mediapackagevod.model.HlsPackage.ReadOnly = new Wrapper(impl)
}
