package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__integer, __string, __boolean}
import scala.jdk.CollectionConverters.*
final case class HlsManifest(
    adMarkers: Option[zio.aws.mediapackagevod.model.AdMarkers] = None,
    includeIframeOnlyStream: Option[__boolean] = None,
    manifestName: Option[__string] = None,
    programDateTimeIntervalSeconds: Option[__integer] = None,
    repeatExtXKey: Option[__boolean] = None,
    streamSelection: Option[zio.aws.mediapackagevod.model.StreamSelection] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.HlsManifest = {
    import HlsManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.HlsManifest
      .builder()
      .optionallyWith(adMarkers.map(value => value.unwrap))(_.adMarkers)
      .optionallyWith(
        includeIframeOnlyStream.map(value => value: java.lang.Boolean)
      )(_.includeIframeOnlyStream)
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value => value: Integer)
      )(_.programDateTimeIntervalSeconds)
      .optionallyWith(repeatExtXKey.map(value => value: java.lang.Boolean))(
        _.repeatExtXKey
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.HlsManifest.ReadOnly =
    zio.aws.mediapackagevod.model.HlsManifest.wrap(buildAwsValue())
}
object HlsManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.HlsManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.HlsManifest =
      zio.aws.mediapackagevod.model.HlsManifest(
        adMarkers.map(value => value),
        includeIframeOnlyStream.map(value => value),
        manifestName.map(value => value),
        programDateTimeIntervalSeconds.map(value => value),
        repeatExtXKey.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def adMarkers: Option[zio.aws.mediapackagevod.model.AdMarkers]
    def includeIframeOnlyStream: Option[__boolean]
    def manifestName: Option[__string]
    def programDateTimeIntervalSeconds: Option[__integer]
    def repeatExtXKey: Option[__boolean]
    def streamSelection
        : Option[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly]
    def getAdMarkers
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.AdMarkers] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getIncludeIframeOnlyStream: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("includeIframeOnlyStream", includeIframeOnlyStream)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getProgramDateTimeIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "programDateTimeIntervalSeconds",
        programDateTimeIntervalSeconds
      )
    def getRepeatExtXKey: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("repeatExtXKey", repeatExtXKey)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.HlsManifest
  ) extends zio.aws.mediapackagevod.model.HlsManifest.ReadOnly {
    override val adMarkers: Option[zio.aws.mediapackagevod.model.AdMarkers] =
      scala
        .Option(impl.adMarkers())
        .map(value => zio.aws.mediapackagevod.model.AdMarkers.wrap(value))
    override val includeIframeOnlyStream: Option[__boolean] = scala
      .Option(impl.includeIframeOnlyStream())
      .map(value => value: __boolean)
    override val manifestName: Option[__string] =
      scala.Option(impl.manifestName()).map(value => value: __string)
    override val programDateTimeIntervalSeconds: Option[__integer] = scala
      .Option(impl.programDateTimeIntervalSeconds())
      .map(value => value: __integer)
    override val repeatExtXKey: Option[__boolean] =
      scala.Option(impl.repeatExtXKey()).map(value => value: __boolean)
    override val streamSelection
        : Option[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly] = scala
      .Option(impl.streamSelection())
      .map(value => zio.aws.mediapackagevod.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.HlsManifest
  ): zio.aws.mediapackagevod.model.HlsManifest.ReadOnly = new Wrapper(impl)
}
