package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EgressEndpoint(
    packagingConfigurationId: Option[__string] = None,
    status: Option[__string] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.EgressEndpoint = {
    import EgressEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.EgressEndpoint
      .builder()
      .optionallyWith(
        packagingConfigurationId.map(value => value: java.lang.String)
      )(_.packagingConfigurationId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly =
    zio.aws.mediapackagevod.model.EgressEndpoint.wrap(buildAwsValue())
}
object EgressEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.EgressEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.EgressEndpoint =
      zio.aws.mediapackagevod.model.EgressEndpoint(
        packagingConfigurationId.map(value => value),
        status.map(value => value),
        url.map(value => value)
      )
    def packagingConfigurationId: Option[__string]
    def status: Option[__string]
    def url: Option[__string]
    def getPackagingConfigurationId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("packagingConfigurationId", packagingConfigurationId)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.EgressEndpoint
  ) extends zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly {
    override val packagingConfigurationId: Option[__string] = scala
      .Option(impl.packagingConfigurationId())
      .map(value => value: __string)
    override val status: Option[__string] =
      scala.Option(impl.status()).map(value => value: __string)
    override val url: Option[__string] =
      scala.Option(impl.url()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.EgressEndpoint
  ): zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly = new Wrapper(impl)
}
