package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EgressAccessLogs(logGroupName: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs = {
    import EgressAccessLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs
      .builder()
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly =
    zio.aws.mediapackagevod.model.EgressAccessLogs.wrap(buildAwsValue())
}
object EgressAccessLogs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.EgressAccessLogs =
      zio.aws.mediapackagevod.model
        .EgressAccessLogs(logGroupName.map(value => value))
    def logGroupName: Option[__string]
    def getLogGroupName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs
  ) extends zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly {
    override val logGroupName: Option[__string] =
      scala.Option(impl.logGroupName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs
  ): zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly = new Wrapper(impl)
}
