package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DescribePackagingGroupResponse(
    arn: Option[__string] = None,
    authorization: Option[zio.aws.mediapackagevod.model.Authorization] = None,
    domainName: Option[__string] = None,
    egressAccessLogs: Option[zio.aws.mediapackagevod.model.EgressAccessLogs] =
      None,
    id: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse = {
    import DescribePackagingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly =
    zio.aws.mediapackagevod.model.DescribePackagingGroupResponse
      .wrap(buildAwsValue())
}
object DescribePackagingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagevod.model.DescribePackagingGroupResponse =
      zio.aws.mediapackagevod.model.DescribePackagingGroupResponse(
        arn.map(value => value),
        authorization.map(value => value.asEditable),
        domainName.map(value => value),
        egressAccessLogs.map(value => value.asEditable),
        id.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def authorization
        : Option[zio.aws.mediapackagevod.model.Authorization.ReadOnly]
    def domainName: Option[__string]
    def egressAccessLogs
        : Option[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly]
    def id: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getDomainName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse
  ) extends zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val authorization
        : Option[zio.aws.mediapackagevod.model.Authorization.ReadOnly] = scala
      .Option(impl.authorization())
      .map(value => zio.aws.mediapackagevod.model.Authorization.wrap(value))
    override val domainName: Option[__string] =
      scala.Option(impl.domainName()).map(value => value: __string)
    override val egressAccessLogs
        : Option[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly] =
      scala
        .Option(impl.egressAccessLogs())
        .map(value =>
          zio.aws.mediapackagevod.model.EgressAccessLogs.wrap(value)
        )
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingGroupResponse
  ): zio.aws.mediapackagevod.model.DescribePackagingGroupResponse.ReadOnly =
    new Wrapper(impl)
}
