package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DescribePackagingConfigurationResponse(
    arn: Option[__string] = None,
    cmafPackage: Option[zio.aws.mediapackagevod.model.CmafPackage] = None,
    dashPackage: Option[zio.aws.mediapackagevod.model.DashPackage] = None,
    hlsPackage: Option[zio.aws.mediapackagevod.model.HlsPackage] = None,
    id: Option[__string] = None,
    mssPackage: Option[zio.aws.mediapackagevod.model.MssPackage] = None,
    packagingGroupId: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse = {
    import DescribePackagingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .optionallyWith(packagingGroupId.map(value => value: java.lang.String))(
        _.packagingGroupId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly =
    zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribePackagingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse =
      zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse(
        arn.map(value => value),
        cmafPackage.map(value => value.asEditable),
        dashPackage.map(value => value.asEditable),
        hlsPackage.map(value => value.asEditable),
        id.map(value => value),
        mssPackage.map(value => value.asEditable),
        packagingGroupId.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def cmafPackage: Option[zio.aws.mediapackagevod.model.CmafPackage.ReadOnly]
    def dashPackage: Option[zio.aws.mediapackagevod.model.DashPackage.ReadOnly]
    def hlsPackage: Option[zio.aws.mediapackagevod.model.HlsPackage.ReadOnly]
    def id: Option[__string]
    def mssPackage: Option[zio.aws.mediapackagevod.model.MssPackage.ReadOnly]
    def packagingGroupId: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCmafPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.CmafPackage.ReadOnly
    ] = AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getDashPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.DashPackage.ReadOnly
    ] = AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getHlsPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.HlsPackage.ReadOnly
    ] = AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMssPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.MssPackage.ReadOnly
    ] = AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getPackagingGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("packagingGroupId", packagingGroupId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse
  ) extends zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val cmafPackage
        : Option[zio.aws.mediapackagevod.model.CmafPackage.ReadOnly] = scala
      .Option(impl.cmafPackage())
      .map(value => zio.aws.mediapackagevod.model.CmafPackage.wrap(value))
    override val dashPackage
        : Option[zio.aws.mediapackagevod.model.DashPackage.ReadOnly] = scala
      .Option(impl.dashPackage())
      .map(value => zio.aws.mediapackagevod.model.DashPackage.wrap(value))
    override val hlsPackage
        : Option[zio.aws.mediapackagevod.model.HlsPackage.ReadOnly] = scala
      .Option(impl.hlsPackage())
      .map(value => zio.aws.mediapackagevod.model.HlsPackage.wrap(value))
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val mssPackage
        : Option[zio.aws.mediapackagevod.model.MssPackage.ReadOnly] = scala
      .Option(impl.mssPackage())
      .map(value => zio.aws.mediapackagevod.model.MssPackage.wrap(value))
    override val packagingGroupId: Option[__string] =
      scala.Option(impl.packagingGroupId()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DescribePackagingConfigurationResponse
  ): zio.aws.mediapackagevod.model.DescribePackagingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
