package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DescribeAssetResponse(
    arn: Option[__string] = None,
    createdAt: Option[__string] = None,
    egressEndpoints: Option[
      Iterable[zio.aws.mediapackagevod.model.EgressEndpoint]
    ] = None,
    id: Option[__string] = None,
    packagingGroupId: Option[__string] = None,
    resourceId: Option[__string] = None,
    sourceArn: Option[__string] = None,
    sourceRoleArn: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse = {
    import DescribeAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(
        egressEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.egressEndpoints)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(packagingGroupId.map(value => value: java.lang.String))(
        _.packagingGroupId
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(sourceRoleArn.map(value => value: java.lang.String))(
        _.sourceRoleArn
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly =
    zio.aws.mediapackagevod.model.DescribeAssetResponse.wrap(buildAwsValue())
}
object DescribeAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.DescribeAssetResponse =
      zio.aws.mediapackagevod.model.DescribeAssetResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        egressEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value => value),
        packagingGroupId.map(value => value),
        resourceId.map(value => value),
        sourceArn.map(value => value),
        sourceRoleArn.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def createdAt: Option[__string]
    def egressEndpoints
        : Option[List[zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly]]
    def id: Option[__string]
    def packagingGroupId: Option[__string]
    def resourceId: Option[__string]
    def sourceArn: Option[__string]
    def sourceRoleArn: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEgressEndpoints: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("egressEndpoints", egressEndpoints)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getPackagingGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("packagingGroupId", packagingGroupId)
    def getResourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getSourceArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getSourceRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceRoleArn", sourceRoleArn)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse
  ) extends zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val createdAt: Option[__string] =
      scala.Option(impl.createdAt()).map(value => value: __string)
    override val egressEndpoints
        : Option[List[zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly]] =
      scala
        .Option(impl.egressEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagevod.model.EgressEndpoint.wrap(item)
          }.toList
        )
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val packagingGroupId: Option[__string] =
      scala.Option(impl.packagingGroupId()).map(value => value: __string)
    override val resourceId: Option[__string] =
      scala.Option(impl.resourceId()).map(value => value: __string)
    override val sourceArn: Option[__string] =
      scala.Option(impl.sourceArn()).map(value => value: __string)
    override val sourceRoleArn: Option[__string] =
      scala.Option(impl.sourceRoleArn()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DescribeAssetResponse
  ): zio.aws.mediapackagevod.model.DescribeAssetResponse.ReadOnly = new Wrapper(
    impl
  )
}
