package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__integer, __boolean}
import scala.jdk.CollectionConverters.*
final case class DashPackage(
    dashManifests: Iterable[zio.aws.mediapackagevod.model.DashManifest],
    encryption: Option[zio.aws.mediapackagevod.model.DashEncryption] = None,
    includeEncoderConfigurationInSegments: Option[__boolean] = None,
    periodTriggers: Option[
      Iterable[zio.aws.mediapackagevod.model.PeriodTriggersElement]
    ] = None,
    segmentDurationSeconds: Option[__integer] = None,
    segmentTemplateFormat: Option[
      zio.aws.mediapackagevod.model.SegmentTemplateFormat
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DashPackage = {
    import DashPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DashPackage
      .builder()
      .dashManifests(dashManifests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        includeEncoderConfigurationInSegments.map(value =>
          value: java.lang.Boolean
        )
      )(_.includeEncoderConfigurationInSegments)
      .optionallyWith(
        periodTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.periodTriggersWithStrings)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(segmentTemplateFormat.map(value => value.unwrap))(
        _.segmentTemplateFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.DashPackage.ReadOnly =
    zio.aws.mediapackagevod.model.DashPackage.wrap(buildAwsValue())
}
object DashPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DashPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.DashPackage =
      zio.aws.mediapackagevod.model.DashPackage(
        dashManifests.map { item =>
          item.asEditable
        },
        encryption.map(value => value.asEditable),
        includeEncoderConfigurationInSegments.map(value => value),
        periodTriggers.map(value => value),
        segmentDurationSeconds.map(value => value),
        segmentTemplateFormat.map(value => value)
      )
    def dashManifests: List[zio.aws.mediapackagevod.model.DashManifest.ReadOnly]
    def encryption
        : Option[zio.aws.mediapackagevod.model.DashEncryption.ReadOnly]
    def includeEncoderConfigurationInSegments: Option[__boolean]
    def periodTriggers
        : Option[List[zio.aws.mediapackagevod.model.PeriodTriggersElement]]
    def segmentDurationSeconds: Option[__integer]
    def segmentTemplateFormat
        : Option[zio.aws.mediapackagevod.model.SegmentTemplateFormat]
    def getDashManifests: ZIO[Any, Nothing, List[
      zio.aws.mediapackagevod.model.DashManifest.ReadOnly
    ]] = ZIO.succeed(dashManifests)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.DashEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getIncludeEncoderConfigurationInSegments
        : ZIO[Any, AwsError, __boolean] = AwsError.unwrapOptionField(
      "includeEncoderConfigurationInSegments",
      includeEncoderConfigurationInSegments
    )
    def getPeriodTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.PeriodTriggersElement
    ]] = AwsError.unwrapOptionField("periodTriggers", periodTriggers)
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentTemplateFormat: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.SegmentTemplateFormat
    ] =
      AwsError.unwrapOptionField("segmentTemplateFormat", segmentTemplateFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashPackage
  ) extends zio.aws.mediapackagevod.model.DashPackage.ReadOnly {
    override val dashManifests
        : List[zio.aws.mediapackagevod.model.DashManifest.ReadOnly] = impl
      .dashManifests()
      .asScala
      .map { item =>
        zio.aws.mediapackagevod.model.DashManifest.wrap(item)
      }
      .toList
    override val encryption
        : Option[zio.aws.mediapackagevod.model.DashEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackagevod.model.DashEncryption.wrap(value))
    override val includeEncoderConfigurationInSegments: Option[__boolean] =
      scala
        .Option(impl.includeEncoderConfigurationInSegments())
        .map(value => value: __boolean)
    override val periodTriggers
        : Option[List[zio.aws.mediapackagevod.model.PeriodTriggersElement]] =
      scala
        .Option(impl.periodTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagevod.model.PeriodTriggersElement.wrap(item)
          }.toList
        )
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
    override val segmentTemplateFormat
        : Option[zio.aws.mediapackagevod.model.SegmentTemplateFormat] = scala
      .Option(impl.segmentTemplateFormat())
      .map(value =>
        zio.aws.mediapackagevod.model.SegmentTemplateFormat.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashPackage
  ): zio.aws.mediapackagevod.model.DashPackage.ReadOnly = new Wrapper(impl)
}
