package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class DashManifest(
    manifestLayout: Option[zio.aws.mediapackagevod.model.ManifestLayout] = None,
    manifestName: Option[__string] = None,
    minBufferTimeSeconds: Option[__integer] = None,
    profile: Option[zio.aws.mediapackagevod.model.Profile] = None,
    streamSelection: Option[zio.aws.mediapackagevod.model.StreamSelection] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.DashManifest = {
    import DashManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.DashManifest
      .builder()
      .optionallyWith(manifestLayout.map(value => value.unwrap))(
        _.manifestLayout
      )
      .optionallyWith(manifestName.map(value => value: java.lang.String))(
        _.manifestName
      )
      .optionallyWith(minBufferTimeSeconds.map(value => value: Integer))(
        _.minBufferTimeSeconds
      )
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.DashManifest.ReadOnly =
    zio.aws.mediapackagevod.model.DashManifest.wrap(buildAwsValue())
}
object DashManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.DashManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.DashManifest =
      zio.aws.mediapackagevod.model.DashManifest(
        manifestLayout.map(value => value),
        manifestName.map(value => value),
        minBufferTimeSeconds.map(value => value),
        profile.map(value => value),
        streamSelection.map(value => value.asEditable)
      )
    def manifestLayout: Option[zio.aws.mediapackagevod.model.ManifestLayout]
    def manifestName: Option[__string]
    def minBufferTimeSeconds: Option[__integer]
    def profile: Option[zio.aws.mediapackagevod.model.Profile]
    def streamSelection
        : Option[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly]
    def getManifestLayout
        : ZIO[Any, AwsError, zio.aws.mediapackagevod.model.ManifestLayout] =
      AwsError.unwrapOptionField("manifestLayout", manifestLayout)
    def getManifestName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("manifestName", manifestName)
    def getMinBufferTimeSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minBufferTimeSeconds", minBufferTimeSeconds)
    def getProfile: ZIO[Any, AwsError, zio.aws.mediapackagevod.model.Profile] =
      AwsError.unwrapOptionField("profile", profile)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashManifest
  ) extends zio.aws.mediapackagevod.model.DashManifest.ReadOnly {
    override val manifestLayout
        : Option[zio.aws.mediapackagevod.model.ManifestLayout] = scala
      .Option(impl.manifestLayout())
      .map(value => zio.aws.mediapackagevod.model.ManifestLayout.wrap(value))
    override val manifestName: Option[__string] =
      scala.Option(impl.manifestName()).map(value => value: __string)
    override val minBufferTimeSeconds: Option[__integer] =
      scala.Option(impl.minBufferTimeSeconds()).map(value => value: __integer)
    override val profile: Option[zio.aws.mediapackagevod.model.Profile] = scala
      .Option(impl.profile())
      .map(value => zio.aws.mediapackagevod.model.Profile.wrap(value))
    override val streamSelection
        : Option[zio.aws.mediapackagevod.model.StreamSelection.ReadOnly] = scala
      .Option(impl.streamSelection())
      .map(value => zio.aws.mediapackagevod.model.StreamSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.DashManifest
  ): zio.aws.mediapackagevod.model.DashManifest.ReadOnly = new Wrapper(impl)
}
