package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreatePackagingGroupRequest(
    authorization: Option[zio.aws.mediapackagevod.model.Authorization] = None,
    egressAccessLogs: Option[zio.aws.mediapackagevod.model.EgressAccessLogs] =
      None,
    id: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest = {
    import CreatePackagingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
      .builder()
      .optionallyWith(authorization.map(value => value.buildAwsValue()))(
        _.authorization
      )
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .id(id: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.CreatePackagingGroupRequest.ReadOnly =
    zio.aws.mediapackagevod.model.CreatePackagingGroupRequest
      .wrap(buildAwsValue())
}
object CreatePackagingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.CreatePackagingGroupRequest =
      zio.aws.mediapackagevod.model.CreatePackagingGroupRequest(
        authorization.map(value => value.asEditable),
        egressAccessLogs.map(value => value.asEditable),
        id,
        tags.map(value => value)
      )
    def authorization
        : Option[zio.aws.mediapackagevod.model.Authorization.ReadOnly]
    def egressAccessLogs
        : Option[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly]
    def id: __string
    def tags: Option[Map[__string, __string]]
    def getAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.Authorization.ReadOnly
    ] = AwsError.unwrapOptionField("authorization", authorization)
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
  ) extends zio.aws.mediapackagevod.model.CreatePackagingGroupRequest.ReadOnly {
    override val authorization
        : Option[zio.aws.mediapackagevod.model.Authorization.ReadOnly] = scala
      .Option(impl.authorization())
      .map(value => zio.aws.mediapackagevod.model.Authorization.wrap(value))
    override val egressAccessLogs
        : Option[zio.aws.mediapackagevod.model.EgressAccessLogs.ReadOnly] =
      scala
        .Option(impl.egressAccessLogs())
        .map(value =>
          zio.aws.mediapackagevod.model.EgressAccessLogs.wrap(value)
        )
    override val id: __string = impl.id(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingGroupRequest
  ): zio.aws.mediapackagevod.model.CreatePackagingGroupRequest.ReadOnly =
    new Wrapper(impl)
}
