package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreatePackagingConfigurationRequest(
    cmafPackage: Option[zio.aws.mediapackagevod.model.CmafPackage] = None,
    dashPackage: Option[zio.aws.mediapackagevod.model.DashPackage] = None,
    hlsPackage: Option[zio.aws.mediapackagevod.model.HlsPackage] = None,
    id: __string,
    mssPackage: Option[zio.aws.mediapackagevod.model.MssPackage] = None,
    packagingGroupId: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest = {
    import CreatePackagingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest
      .builder()
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .id(id: java.lang.String)
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .packagingGroupId(packagingGroupId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.CreatePackagingConfigurationRequest.ReadOnly =
    zio.aws.mediapackagevod.model.CreatePackagingConfigurationRequest
      .wrap(buildAwsValue())
}
object CreatePackagingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagevod.model.CreatePackagingConfigurationRequest =
      zio.aws.mediapackagevod.model.CreatePackagingConfigurationRequest(
        cmafPackage.map(value => value.asEditable),
        dashPackage.map(value => value.asEditable),
        hlsPackage.map(value => value.asEditable),
        id,
        mssPackage.map(value => value.asEditable),
        packagingGroupId,
        tags.map(value => value)
      )
    def cmafPackage: Option[zio.aws.mediapackagevod.model.CmafPackage.ReadOnly]
    def dashPackage: Option[zio.aws.mediapackagevod.model.DashPackage.ReadOnly]
    def hlsPackage: Option[zio.aws.mediapackagevod.model.HlsPackage.ReadOnly]
    def id: __string
    def mssPackage: Option[zio.aws.mediapackagevod.model.MssPackage.ReadOnly]
    def packagingGroupId: __string
    def tags: Option[Map[__string, __string]]
    def getCmafPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.CmafPackage.ReadOnly
    ] = AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getDashPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.DashPackage.ReadOnly
    ] = AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getHlsPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.HlsPackage.ReadOnly
    ] = AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getMssPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.MssPackage.ReadOnly
    ] = AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getPackagingGroupId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(packagingGroupId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest
  ) extends zio.aws.mediapackagevod.model.CreatePackagingConfigurationRequest.ReadOnly {
    override val cmafPackage
        : Option[zio.aws.mediapackagevod.model.CmafPackage.ReadOnly] = scala
      .Option(impl.cmafPackage())
      .map(value => zio.aws.mediapackagevod.model.CmafPackage.wrap(value))
    override val dashPackage
        : Option[zio.aws.mediapackagevod.model.DashPackage.ReadOnly] = scala
      .Option(impl.dashPackage())
      .map(value => zio.aws.mediapackagevod.model.DashPackage.wrap(value))
    override val hlsPackage
        : Option[zio.aws.mediapackagevod.model.HlsPackage.ReadOnly] = scala
      .Option(impl.hlsPackage())
      .map(value => zio.aws.mediapackagevod.model.HlsPackage.wrap(value))
    override val id: __string = impl.id(): __string
    override val mssPackage
        : Option[zio.aws.mediapackagevod.model.MssPackage.ReadOnly] = scala
      .Option(impl.mssPackage())
      .map(value => zio.aws.mediapackagevod.model.MssPackage.wrap(value))
    override val packagingGroupId: __string = impl.packagingGroupId(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationRequest
  ): zio.aws.mediapackagevod.model.CreatePackagingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
