package zio.aws.mediapackagevod.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.{__integer, __boolean}
import scala.jdk.CollectionConverters.*
final case class CmafPackage(
    encryption: Option[zio.aws.mediapackagevod.model.CmafEncryption] = None,
    hlsManifests: Iterable[zio.aws.mediapackagevod.model.HlsManifest],
    includeEncoderConfigurationInSegments: Option[__boolean] = None,
    segmentDurationSeconds: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CmafPackage = {
    import CmafPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CmafPackage
      .builder()
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .hlsManifests(hlsManifests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        includeEncoderConfigurationInSegments.map(value =>
          value: java.lang.Boolean
        )
      )(_.includeEncoderConfigurationInSegments)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.CmafPackage.ReadOnly =
    zio.aws.mediapackagevod.model.CmafPackage.wrap(buildAwsValue())
}
object CmafPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CmafPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.CmafPackage =
      zio.aws.mediapackagevod.model.CmafPackage(
        encryption.map(value => value.asEditable),
        hlsManifests.map { item =>
          item.asEditable
        },
        includeEncoderConfigurationInSegments.map(value => value),
        segmentDurationSeconds.map(value => value)
      )
    def encryption
        : Option[zio.aws.mediapackagevod.model.CmafEncryption.ReadOnly]
    def hlsManifests: List[zio.aws.mediapackagevod.model.HlsManifest.ReadOnly]
    def includeEncoderConfigurationInSegments: Option[__boolean]
    def segmentDurationSeconds: Option[__integer]
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.CmafEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getHlsManifests: ZIO[Any, Nothing, List[
      zio.aws.mediapackagevod.model.HlsManifest.ReadOnly
    ]] = ZIO.succeed(hlsManifests)
    def getIncludeEncoderConfigurationInSegments
        : ZIO[Any, AwsError, __boolean] = AwsError.unwrapOptionField(
      "includeEncoderConfigurationInSegments",
      includeEncoderConfigurationInSegments
    )
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CmafPackage
  ) extends zio.aws.mediapackagevod.model.CmafPackage.ReadOnly {
    override val encryption
        : Option[zio.aws.mediapackagevod.model.CmafEncryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.mediapackagevod.model.CmafEncryption.wrap(value))
    override val hlsManifests
        : List[zio.aws.mediapackagevod.model.HlsManifest.ReadOnly] = impl
      .hlsManifests()
      .asScala
      .map { item =>
        zio.aws.mediapackagevod.model.HlsManifest.wrap(item)
      }
      .toList
    override val includeEncoderConfigurationInSegments: Option[__boolean] =
      scala
        .Option(impl.includeEncoderConfigurationInSegments())
        .map(value => value: __boolean)
    override val segmentDurationSeconds: Option[__integer] =
      scala.Option(impl.segmentDurationSeconds()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CmafPackage
  ): zio.aws.mediapackagevod.model.CmafPackage.ReadOnly = new Wrapper(impl)
}
