package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CmafEncryption(
    constantInitializationVector: Option[__string] = None,
    spekeKeyProvider: zio.aws.mediapackagevod.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CmafEncryption = {
    import CmafEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CmafEncryption
      .builder()
      .optionallyWith(
        constantInitializationVector.map(value => value: java.lang.String)
      )(_.constantInitializationVector)
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.CmafEncryption.ReadOnly =
    zio.aws.mediapackagevod.model.CmafEncryption.wrap(buildAwsValue())
}
object CmafEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CmafEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.CmafEncryption =
      zio.aws.mediapackagevod.model.CmafEncryption(
        constantInitializationVector.map(value => value),
        spekeKeyProvider.asEditable
      )
    def constantInitializationVector: Option[__string]
    def spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    def getConstantInitializationVector: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "constantInitializationVector",
        constantInitializationVector
      )
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CmafEncryption
  ) extends zio.aws.mediapackagevod.model.CmafEncryption.ReadOnly {
    override val constantInitializationVector: Option[__string] = scala
      .Option(impl.constantInitializationVector())
      .map(value => value: __string)
    override val spekeKeyProvider
        : zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackagevod.model.SpekeKeyProvider
        .wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CmafEncryption
  ): zio.aws.mediapackagevod.model.CmafEncryption.ReadOnly = new Wrapper(impl)
}
