package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  TagValue,
  TagKey,
  ResourceDescription,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class UpdateChannelResponse(
    arn: String,
    channelName: String,
    channelGroupName: String,
    createdAt: Timestamp,
    modifiedAt: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent,
    ingestEndpoints: Optional[
      Iterable[zio.aws.mediapackagev2.model.IngestEndpoint]
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse
      .builder()
      .arn(arn: java.lang.String)
      .channelName(channelName: java.lang.String)
      .channelGroupName(channelGroupName: java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .modifiedAt(Timestamp.unwrap(modifiedAt): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ingestEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ingestEndpoints)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly =
    zio.aws.mediapackagev2.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.UpdateChannelResponse =
      zio.aws.mediapackagev2.model.UpdateChannelResponse(
        arn,
        channelName,
        channelGroupName,
        createdAt,
        modifiedAt,
        description.map(value => value),
        ingestEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def arn: String
    def channelName: String
    def channelGroupName: String
    def createdAt: Timestamp
    def modifiedAt: Timestamp
    def description: Optional[ResourceDescription]
    def ingestEndpoints
        : Optional[List[zio.aws.mediapackagev2.model.IngestEndpoint.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getChannelName: ZIO[Any, Nothing, String] = ZIO.succeed(channelName)
    def getChannelGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(channelGroupName)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedAt)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIngestEndpoints: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.IngestEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("ingestEndpoints", ingestEndpoints)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse
  ) extends zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly {
    override val arn: String = impl.arn(): String
    override val channelName: String = impl.channelName(): String
    override val channelGroupName: String = impl.channelGroupName(): String
    override val createdAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.createdAt())
    override val modifiedAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.modifiedAt())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
    override val ingestEndpoints
        : Optional[List[zio.aws.mediapackagev2.model.IngestEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagev2.model.IngestEndpoint.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediapackagev2.model.primitives.TagKey(
              key
            ) -> zio.aws.mediapackagev2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelResponse
  ): zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
