package zio.aws.mediapackagev2.model
import scala.jdk.CollectionConverters.*
sealed trait TsEncryptionMethod {
  def unwrap
      : software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod
}
object TsEncryptionMethod {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod
  ): zio.aws.mediapackagev2.model.TsEncryptionMethod = value match {
    case software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod.AES_128 =>
      val r = AES_128
      r
    case software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod.SAMPLE_AES =>
      val r = SAMPLE_AES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagev2.model.TsEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod =
      software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object AES_128 extends zio.aws.mediapackagev2.model.TsEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod =
      software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod.AES_128
  }
  case object SAMPLE_AES
      extends zio.aws.mediapackagev2.model.TsEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod =
      software.amazon.awssdk.services.mediapackagev2.model.TsEncryptionMethod.SAMPLE_AES
  }
}
