package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{
  SpekeKeyProviderUrlString,
  SpekeKeyProviderRoleArnString,
  SpekeKeyProviderResourceIdString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SpekeKeyProvider(
    encryptionContractConfiguration: zio.aws.mediapackagev2.model.EncryptionContractConfiguration,
    resourceId: SpekeKeyProviderResourceIdString,
    drmSystems: Iterable[zio.aws.mediapackagev2.model.DrmSystem],
    roleArn: SpekeKeyProviderRoleArnString,
    url: SpekeKeyProviderUrlString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProvider = {
    import SpekeKeyProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProvider
      .builder()
      .encryptionContractConfiguration(
        encryptionContractConfiguration.buildAwsValue()
      )
      .resourceId(
        SpekeKeyProviderResourceIdString.unwrap(resourceId): java.lang.String
      )
      .drmSystemsWithStrings(drmSystems.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .roleArn(SpekeKeyProviderRoleArnString.unwrap(roleArn): java.lang.String)
      .url(SpekeKeyProviderUrlString.unwrap(url): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.SpekeKeyProvider.ReadOnly =
    zio.aws.mediapackagev2.model.SpekeKeyProvider.wrap(buildAwsValue())
}
object SpekeKeyProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.SpekeKeyProvider =
      zio.aws.mediapackagev2.model.SpekeKeyProvider(
        encryptionContractConfiguration.asEditable,
        resourceId,
        drmSystems,
        roleArn,
        url
      )
    def encryptionContractConfiguration
        : zio.aws.mediapackagev2.model.EncryptionContractConfiguration.ReadOnly
    def resourceId: SpekeKeyProviderResourceIdString
    def drmSystems: List[zio.aws.mediapackagev2.model.DrmSystem]
    def roleArn: SpekeKeyProviderRoleArnString
    def url: SpekeKeyProviderUrlString
    def getEncryptionContractConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagev2.model.EncryptionContractConfiguration.ReadOnly
    ] = ZIO.succeed(encryptionContractConfiguration)
    def getResourceId: ZIO[Any, Nothing, SpekeKeyProviderResourceIdString] =
      ZIO.succeed(resourceId)
    def getDrmSystems
        : ZIO[Any, Nothing, List[zio.aws.mediapackagev2.model.DrmSystem]] =
      ZIO.succeed(drmSystems)
    def getRoleArn: ZIO[Any, Nothing, SpekeKeyProviderRoleArnString] =
      ZIO.succeed(roleArn)
    def getUrl: ZIO[Any, Nothing, SpekeKeyProviderUrlString] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProvider
  ) extends zio.aws.mediapackagev2.model.SpekeKeyProvider.ReadOnly {
    override val encryptionContractConfiguration
        : zio.aws.mediapackagev2.model.EncryptionContractConfiguration.ReadOnly =
      zio.aws.mediapackagev2.model.EncryptionContractConfiguration
        .wrap(impl.encryptionContractConfiguration())
    override val resourceId: SpekeKeyProviderResourceIdString =
      zio.aws.mediapackagev2.model.primitives
        .SpekeKeyProviderResourceIdString(impl.resourceId())
    override val drmSystems: List[zio.aws.mediapackagev2.model.DrmSystem] = impl
      .drmSystems()
      .asScala
      .map { item =>
        zio.aws.mediapackagev2.model.DrmSystem.wrap(item)
      }
      .toList
    override val roleArn: SpekeKeyProviderRoleArnString =
      zio.aws.mediapackagev2.model.primitives
        .SpekeKeyProviderRoleArnString(impl.roleArn())
    override val url: SpekeKeyProviderUrlString =
      zio.aws.mediapackagev2.model.primitives
        .SpekeKeyProviderUrlString(impl.url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.SpekeKeyProvider
  ): zio.aws.mediapackagev2.model.SpekeKeyProvider.ReadOnly = new Wrapper(impl)
}
