package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOriginEndpointsResponse(
    items: Optional[
      Iterable[zio.aws.mediapackagev2.model.OriginEndpointListConfiguration]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse = {
    import ListOriginEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly =
    zio.aws.mediapackagev2.model.ListOriginEndpointsResponse
      .wrap(buildAwsValue())
}
object ListOriginEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListOriginEndpointsResponse =
      zio.aws.mediapackagev2.model.ListOriginEndpointsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[
      zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse
  ) extends zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly {
    override val items: Optional[List[
      zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.OriginEndpointListConfiguration
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse
  ): zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
