package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteChannelRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest = {
    import DeleteChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.DeleteChannelRequest.ReadOnly =
    zio.aws.mediapackagev2.model.DeleteChannelRequest.wrap(buildAwsValue())
}
object DeleteChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.DeleteChannelRequest =
      zio.aws.mediapackagev2.model
        .DeleteChannelRequest(channelGroupName, channelName)
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest
  ) extends zio.aws.mediapackagev2.model.DeleteChannelRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest
  ): zio.aws.mediapackagev2.model.DeleteChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
