package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScteHls(
    adMarkerHls: Optional[zio.aws.mediapackagev2.model.AdMarkerHls] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ScteHls = {
    import ScteHls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ScteHls
      .builder()
      .optionallyWith(adMarkerHls.map(value => value.unwrap))(_.adMarkerHls)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.ScteHls.ReadOnly =
    zio.aws.mediapackagev2.model.ScteHls.wrap(buildAwsValue())
}
object ScteHls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ScteHls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ScteHls =
      zio.aws.mediapackagev2.model.ScteHls(adMarkerHls.map(value => value))
    def adMarkerHls: Optional[zio.aws.mediapackagev2.model.AdMarkerHls]
    def getAdMarkerHls
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.AdMarkerHls] =
      AwsError.unwrapOptionField("adMarkerHls", adMarkerHls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ScteHls
  ) extends zio.aws.mediapackagev2.model.ScteHls.ReadOnly {
    override val adMarkerHls
        : Optional[zio.aws.mediapackagev2.model.AdMarkerHls] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adMarkerHls())
        .map(value => zio.aws.mediapackagev2.model.AdMarkerHls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ScteHls
  ): zio.aws.mediapackagev2.model.ScteHls.ReadOnly = new Wrapper(impl)
}
